using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;
using System.Data;
using Microsoft.Reporting.WinForms;
using System.Reflection;
using System.IO;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class FrmTransfusionReport
	/// </summary>
	public class FrmTransfusionReport : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.Button btnCancel;
        private System.Windows.Forms.Button btnPrint;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.ComponentModel.IContainer components = null;
        private gov.va.med.vbecs.GUI.controls.VbecsReportViewer rvDivisionTransfusion;
		private System.Windows.Forms.PrintDialog printDialog1;

		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="reportSource"></param>
		/// <param name="reportType"></param>
		/// <param name="startDate"></param>
		/// <param name="endDate"></param>
		/// <param name="reportCriteria"></param>
		public FrmTransfusionReport(DataSet reportSource, Common.TransfusionReportType reportType, DateTime startDate, DateTime endDate, string reportCriteria)
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();
			SetComponentProperties();
			LoadTransfusionReport(reportSource, reportType, startDate, endDate, reportCriteria);
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(FrmTransfusionReport));
            this.grpImage = new System.Windows.Forms.GroupBox();
            this.pictureBox1 = new System.Windows.Forms.PictureBox();
            this.btnCancel = new System.Windows.Forms.Button();
            this.btnPrint = new System.Windows.Forms.Button();
            this.printDialog1 = new System.Windows.Forms.PrintDialog();
            this.rvDivisionTransfusion = new gov.va.med.vbecs.GUI.controls.VbecsReportViewer();
            ((System.ComponentModel.ISupportInitialize)(this.errError)).BeginInit();
            this.grpImage.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox1)).BeginInit();
            this.SuspendLayout();
            // 
            // vbecsLogo1
            // 
            this.vbecsLogo1.TabIndex = 3;
            this.vbecsLogo1.Title = "Division Transfusion Report";
            // 
            // lblRequiredField
            // 
            this.lblRequiredField.TabIndex = 5;
            // 
            // grpImage
            // 
            this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left)));
            this.grpImage.BackColor = System.Drawing.SystemColors.Control;
            this.grpImage.Controls.Add(this.pictureBox1);
            this.grpImage.Location = new System.Drawing.Point(4, 32);
            this.grpImage.Name = "grpImage";
            this.grpImage.Size = new System.Drawing.Size(52, 410);
            this.grpImage.TabIndex = 4;
            this.grpImage.TabStop = false;
            // 
            // pictureBox1
            // 
            this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
            this.pictureBox1.Location = new System.Drawing.Point(4, 8);
            this.pictureBox1.Name = "pictureBox1";
            this.pictureBox1.Size = new System.Drawing.Size(45, 45);
            this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
            this.pictureBox1.TabIndex = 0;
            this.pictureBox1.TabStop = false;
            // 
            // btnCancel
            // 
            this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this.btnCancel.Location = new System.Drawing.Point(564, 446);
            this.btnCancel.Name = "btnCancel";
            this.btnCancel.Size = new System.Drawing.Size(75, 23);
            this.btnCancel.TabIndex = 2;
            this.btnCancel.Text = "&Close";
            this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
            // 
            // btnPrint
            // 
            this.btnPrint.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnPrint.DialogResult = System.Windows.Forms.DialogResult.OK;
            this.btnPrint.Image = ((System.Drawing.Image)(resources.GetObject("btnPrint.Image")));
            this.btnPrint.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
            this.btnPrint.Location = new System.Drawing.Point(484, 446);
            this.btnPrint.Name = "btnPrint";
            this.btnPrint.Size = new System.Drawing.Size(75, 23);
            this.btnPrint.TabIndex = 1;
            this.btnPrint.Text = "&Print";
            this.btnPrint.Click += new System.EventHandler(this.btnPrint_Click);
            // 
            // printDialog1
            // 
            this.printDialog1.AllowPrintToFile = false;
            // 
            // rvDivisionTransfusion
            // 
            this.rvDivisionTransfusion.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.rvDivisionTransfusion.Location = new System.Drawing.Point(60, 37);
            this.rvDivisionTransfusion.Name = "rvDivisionTransfusion";
            this.rvDivisionTransfusion.Size = new System.Drawing.Size(579, 403);
            this.rvDivisionTransfusion.TabIndex = 6;
            this.rvDivisionTransfusion.RenderingComplete += new Microsoft.Reporting.WinForms.RenderingCompleteEventHandler(this.rvDivisionTransfusion_RenderingComplete);
            this.rvDivisionTransfusion.RenderingBegin += new System.ComponentModel.CancelEventHandler(this.rvDivisionTransfusion_RenderingBegin);
            // 
            // FrmTransfusionReport
            // 
            this.AcceptButton = this.btnPrint;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.CancelButton = this.btnCancel;
            this.ClientSize = new System.Drawing.Size(642, 473);
            this.Controls.Add(this.rvDivisionTransfusion);
            this.Controls.Add(this.grpImage);
            this.Controls.Add(this.btnCancel);
            this.Controls.Add(this.btnPrint);
            this.hlphelpChm.SetHelpKeyword(this, "Division_Transfusion_Report.htm");
            this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
            this.MinimumSize = new System.Drawing.Size(600, 450);
            this.Name = "FrmTransfusionReport";
            this.RequiredFieldsLabel = true;
            this.hlphelpChm.SetShowHelp(this, true);
            this.Text = "VBECS - Division Transfusion Report";
            this.Load += new System.EventHandler(this.FrmTransfusionReport_Load);
            this.Controls.SetChildIndex(this.vbecsLogo1, 0);
            this.Controls.SetChildIndex(this.lblRequiredField, 0);
            this.Controls.SetChildIndex(this.btnPrint, 0);
            this.Controls.SetChildIndex(this.btnCancel, 0);
            this.Controls.SetChildIndex(this.grpImage, 0);
            this.Controls.SetChildIndex(this.rvDivisionTransfusion, 0);
            ((System.ComponentModel.ISupportInitialize)(this.errError)).EndInit();
            this.grpImage.ResumeLayout(false);
            this.grpImage.PerformLayout();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox1)).EndInit();
            this.ResumeLayout(false);
            this.PerformLayout();

		}
		#endregion

		private void SetComponentProperties()
		{
			this.vbecsLogo1.Title = this.Text.Replace("VBECS - ","");
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC074.FrmTransfusionReport());
            BOL.VbecsReport.SetUpReportButtons(this.rvDivisionTransfusion);
        }

		private void LoadTransfusionReport(DataSet reportSource, Common.TransfusionReportType reportType, DateTime startDate, DateTime endDate, string reportCriteria)
		{
#if DEBUG
			//reportSource.Tables[0].WriteXml("e:\\temp\\DivisionTransfusionDataSet.xml", XmlWriteMode.WriteSchema);
#endif
			string dateCriteria = "Date Range: ";
			dateCriteria += Common.VBECSDateTime.FormatDateString(startDate);
			dateCriteria += " - ";
			dateCriteria += Common.VBECSDateTime.FormatDateString(endDate);

			reportCriteria = dateCriteria + ", " + reportCriteria;
			DataSet dsHeader =  BOL.VbecsReport.GetReportHeader(ThisUser.UserName);
			DataSet dsFooter = BOL.VbecsReport.GetReportFooter(reportCriteria);

            ReportDataSource reportSourceMain = new ReportDataSource();
            if (reportSource.Tables.Count > 0)
            {
                reportSourceMain.Name = "DivisionTransfusionDataSet";
                reportSourceMain.Value = reportSource.Tables[0];
            }
            
            ReportDataSource reportSourceHeader = new ReportDataSource();
            if (dsHeader.Tables.Count > 0)
            {
                reportSourceHeader.Name = "ReportHeaderDataSet";
                reportSourceHeader.Value = dsHeader.Tables[0];
            }

            ReportDataSource reportSourceFooter = new ReportDataSource();
            if (dsFooter.Tables.Count > 0)
            {
                reportSourceFooter.Name = "ReportFooterDataSet";
                reportSourceFooter.Value = dsFooter.Tables[0];
            }

            Assembly assembly = Assembly.LoadFrom("Reports.dll");

            switch (reportType)
            {
                case Common.TransfusionReportType.Physician:
                         Stream streamPhysician = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.DivisionTransfusionReport.DivisionTransfusionByPhysician.rdlc");
                         this.rvDivisionTransfusion.LocalReport.DataSources.Add(reportSourceHeader);
                         this.rvDivisionTransfusion.LocalReport.DataSources.Add(reportSourceFooter);
                         this.rvDivisionTransfusion.LocalReport.DataSources.Add(reportSourceMain);
                         this.rvDivisionTransfusion.LocalReport.LoadReportDefinition(streamPhysician);
                   break;

                case Common.TransfusionReportType.IssueToLocation:
                         Stream streamIssueToLocation = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.DivisionTransfusionReport.DivisionTransfusionByIssueToLocation.rdlc");
                         this.rvDivisionTransfusion.LocalReport.DataSources.Add(reportSourceHeader);
                         this.rvDivisionTransfusion.LocalReport.DataSources.Add(reportSourceFooter);
                         this.rvDivisionTransfusion.LocalReport.DataSources.Add(reportSourceMain);
                         this.rvDivisionTransfusion.LocalReport.LoadReportDefinition(streamIssueToLocation);
                    break;

                case Common.TransfusionReportType.TreatingSpecialty:
                         Stream streamTreatingSpecialty = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.DivisionTransfusionReport.DivisionTransfusionByTreatingSpecialty.rdlc");
                         this.rvDivisionTransfusion.LocalReport.DataSources.Add(reportSourceHeader);
                         this.rvDivisionTransfusion.LocalReport.DataSources.Add(reportSourceFooter);
                         this.rvDivisionTransfusion.LocalReport.DataSources.Add(reportSourceMain);
                         this.rvDivisionTransfusion.LocalReport.LoadReportDefinition(streamTreatingSpecialty);
                    break;
            }
            this.rvDivisionTransfusion.RefreshReport();
		}

		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		private void btnPrint_Click(object sender, System.EventArgs e)
		{
            //CR 3449
            try
            {
                this.rvDivisionTransfusion.PrintDialog();
            }
            catch (System.InvalidOperationException)
            {
            }
        }

        private void FrmTransfusionReport_Load(object sender, EventArgs e)
        {

            this.rvDivisionTransfusion.RefreshReport();
        }

        /// <summary>
        /// CR 3581
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void rvDivisionTransfusion_RenderingBegin(object sender, CancelEventArgs e)
        {
            this.btnPrint.Enabled = false;
        }

        /// <summary>
        /// CR 3581
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void rvDivisionTransfusion_RenderingComplete(object sender, RenderingCompleteEventArgs e)
        {
            this.btnPrint.Enabled = true;
        }
	}
}

